/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.RateQueueProperty;

public class RateQueuePropertyBuilder {
    private Integer _rate;

    public Integer getRate() {
        return this._rate;
    }

    public RateQueuePropertyBuilder setRate(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rate = value;
        return this;
    }

    public RateQueueProperty build() {
        return new RateQueuePropertyImpl(this);
    }

    private static final class RateQueuePropertyImpl
    implements RateQueueProperty {
        private final Integer _rate;

        public Class<RateQueueProperty> getImplementedInterface() {
            return RateQueueProperty.class;
        }

        private RateQueuePropertyImpl(RateQueuePropertyBuilder builder) {
            this._rate = builder.getRate();
        }

        @Override
        public Integer getRate() {
            return this._rate;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._rate == null ? 0 : this._rate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RateQueuePropertyImpl other = (RateQueuePropertyImpl)obj;
            return !(this._rate == null ? other._rate != null : !this._rate.equals(other._rate));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RateQueueProperty [_rate=");
            builder.append(this._rate);
            builder.append("]");
            return builder.toString();
        }
    }
}

