/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdAction;

public class QueueIdActionBuilder {
    private Long _queueId;

    public Long getQueueId() {
        return this._queueId;
    }

    public QueueIdActionBuilder setQueueId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._queueId = value;
        return this;
    }

    public QueueIdAction build() {
        return new QueueIdActionImpl(this);
    }

    private static final class QueueIdActionImpl
    implements QueueIdAction {
        private final Long _queueId;

        public Class<QueueIdAction> getImplementedInterface() {
            return QueueIdAction.class;
        }

        private QueueIdActionImpl(QueueIdActionBuilder builder) {
            this._queueId = builder.getQueueId();
        }

        @Override
        public Long getQueueId() {
            return this._queueId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._queueId == null ? 0 : this._queueId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueIdActionImpl other = (QueueIdActionImpl)obj;
            return !(this._queueId == null ? other._queueId != null : !this._queueId.equals(other._queueId));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("QueueIdAction [_queueId=");
            builder.append(this._queueId);
            builder.append("]");
            return builder.toString();
        }
    }
}

