/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntry;

public class ProtocolNumberMatchEntryBuilder {
    private Short _protocolNumber;

    public Short getProtocolNumber() {
        return this._protocolNumber;
    }

    public ProtocolNumberMatchEntryBuilder setProtocolNumber(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._protocolNumber = value;
        return this;
    }

    public ProtocolNumberMatchEntry build() {
        return new ProtocolNumberMatchEntryImpl(this);
    }

    private static final class ProtocolNumberMatchEntryImpl
    implements ProtocolNumberMatchEntry {
        private final Short _protocolNumber;

        public Class<ProtocolNumberMatchEntry> getImplementedInterface() {
            return ProtocolNumberMatchEntry.class;
        }

        private ProtocolNumberMatchEntryImpl(ProtocolNumberMatchEntryBuilder builder) {
            this._protocolNumber = builder.getProtocolNumber();
        }

        @Override
        public Short getProtocolNumber() {
            return this._protocolNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._protocolNumber == null ? 0 : this._protocolNumber.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProtocolNumberMatchEntryImpl other = (ProtocolNumberMatchEntryImpl)obj;
            return !(this._protocolNumber == null ? other._protocolNumber != null : !this._protocolNumber.equals(other._protocolNumber));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ProtocolNumberMatchEntry [_protocolNumber=");
            builder.append(this._protocolNumber);
            builder.append("]");
            return builder.toString();
        }
    }
}

