/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntry;

public class OpCodeMatchEntryBuilder {
    private Integer _opCode;

    public Integer getOpCode() {
        return this._opCode;
    }

    public OpCodeMatchEntryBuilder setOpCode(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._opCode = value;
        return this;
    }

    public OpCodeMatchEntry build() {
        return new OpCodeMatchEntryImpl(this);
    }

    private static final class OpCodeMatchEntryImpl
    implements OpCodeMatchEntry {
        private final Integer _opCode;

        public Class<OpCodeMatchEntry> getImplementedInterface() {
            return OpCodeMatchEntry.class;
        }

        private OpCodeMatchEntryImpl(OpCodeMatchEntryBuilder builder) {
            this._opCode = builder.getOpCode();
        }

        @Override
        public Integer getOpCode() {
            return this._opCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._opCode == null ? 0 : this._opCode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OpCodeMatchEntryImpl other = (OpCodeMatchEntryImpl)obj;
            return !(this._opCode == null ? other._opCode != null : !this._opCode.equals(other._opCode));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OpCodeMatchEntry [_opCode=");
            builder.append(this._opCode);
            builder.append("]");
            return builder.toString();
        }
    }
}

