/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTosAction;

public class NwTosActionBuilder {
    private Short _nwTos;

    public Short getNwTos() {
        return this._nwTos;
    }

    public NwTosActionBuilder setNwTos(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwTos = value;
        return this;
    }

    public NwTosAction build() {
        return new NwTosActionImpl(this);
    }

    private static final class NwTosActionImpl
    implements NwTosAction {
        private final Short _nwTos;

        public Class<NwTosAction> getImplementedInterface() {
            return NwTosAction.class;
        }

        private NwTosActionImpl(NwTosActionBuilder builder) {
            this._nwTos = builder.getNwTos();
        }

        @Override
        public Short getNwTos() {
            return this._nwTos;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nwTos == null ? 0 : this._nwTos.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NwTosActionImpl other = (NwTosActionImpl)obj;
            return !(this._nwTos == null ? other._nwTos != null : !this._nwTos.equals(other._nwTos));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NwTosAction [_nwTos=");
            builder.append(this._nwTos);
            builder.append("]");
            return builder.toString();
        }
    }
}

