/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsTtlAction;

public class MplsTtlActionBuilder {
    private Short _mplsTtl;

    public Short getMplsTtl() {
        return this._mplsTtl;
    }

    public MplsTtlActionBuilder setMplsTtl(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._mplsTtl = value;
        return this;
    }

    public MplsTtlAction build() {
        return new MplsTtlActionImpl(this);
    }

    private static final class MplsTtlActionImpl
    implements MplsTtlAction {
        private final Short _mplsTtl;

        public Class<MplsTtlAction> getImplementedInterface() {
            return MplsTtlAction.class;
        }

        private MplsTtlActionImpl(MplsTtlActionBuilder builder) {
            this._mplsTtl = builder.getMplsTtl();
        }

        @Override
        public Short getMplsTtl() {
            return this._mplsTtl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._mplsTtl == null ? 0 : this._mplsTtl.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MplsTtlActionImpl other = (MplsTtlActionImpl)obj;
            return !(this._mplsTtl == null ? other._mplsTtl != null : !this._mplsTtl.equals(other._mplsTtl));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MplsTtlAction [_mplsTtl=");
            builder.append(this._mplsTtl);
            builder.append("]");
            return builder.toString();
        }
    }
}

