/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MeterIdInstruction;

public class MeterIdInstructionBuilder {
    private Long _meterId;

    public Long getMeterId() {
        return this._meterId;
    }

    public MeterIdInstructionBuilder setMeterId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._meterId = value;
        return this;
    }

    public MeterIdInstruction build() {
        return new MeterIdInstructionImpl(this);
    }

    private static final class MeterIdInstructionImpl
    implements MeterIdInstruction {
        private final Long _meterId;

        public Class<MeterIdInstruction> getImplementedInterface() {
            return MeterIdInstruction.class;
        }

        private MeterIdInstructionImpl(MeterIdInstructionBuilder builder) {
            this._meterId = builder.getMeterId();
        }

        @Override
        public Long getMeterId() {
            return this._meterId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterIdInstructionImpl other = (MeterIdInstructionImpl)obj;
            return !(this._meterId == null ? other._meterId != null : !this._meterId.equals(other._meterId));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterIdInstruction [_meterId=");
            builder.append(this._meterId);
            builder.append("]");
            return builder.toString();
        }
    }
}

