/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;

public class MaxLengthActionBuilder {
    private Integer _maxLength;

    public Integer getMaxLength() {
        return this._maxLength;
    }

    public MaxLengthActionBuilder setMaxLength(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxLength = value;
        return this;
    }

    public MaxLengthAction build() {
        return new MaxLengthActionImpl(this);
    }

    private static final class MaxLengthActionImpl
    implements MaxLengthAction {
        private final Integer _maxLength;

        public Class<MaxLengthAction> getImplementedInterface() {
            return MaxLengthAction.class;
        }

        private MaxLengthActionImpl(MaxLengthActionBuilder builder) {
            this._maxLength = builder.getMaxLength();
        }

        @Override
        public Integer getMaxLength() {
            return this._maxLength;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxLength == null ? 0 : this._maxLength.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MaxLengthActionImpl other = (MaxLengthActionImpl)obj;
            return !(this._maxLength == null ? other._maxLength != null : !this._maxLength.equals(other._maxLength));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MaxLengthAction [_maxLength=");
            builder.append(this._maxLength);
            builder.append("]");
            return builder.toString();
        }
    }
}

