/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntry;

public class IsidMatchEntryBuilder {
    private Long _isid;

    public Long getIsid() {
        return this._isid;
    }

    public IsidMatchEntryBuilder setIsid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._isid = value;
        return this;
    }

    public IsidMatchEntry build() {
        return new IsidMatchEntryImpl(this);
    }

    private static final class IsidMatchEntryImpl
    implements IsidMatchEntry {
        private final Long _isid;

        public Class<IsidMatchEntry> getImplementedInterface() {
            return IsidMatchEntry.class;
        }

        private IsidMatchEntryImpl(IsidMatchEntryBuilder builder) {
            this._isid = builder.getIsid();
        }

        @Override
        public Long getIsid() {
            return this._isid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._isid == null ? 0 : this._isid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IsidMatchEntryImpl other = (IsidMatchEntryImpl)obj;
            return !(this._isid == null ? other._isid != null : !this._isid.equals(other._isid));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IsidMatchEntry [_isid=");
            builder.append(this._isid);
            builder.append("]");
            return builder.toString();
        }
    }
}

