/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntry;

public class Icmpv6TypeMatchEntryBuilder {
    private Short _icmpv6Type;

    public Short getIcmpv6Type() {
        return this._icmpv6Type;
    }

    public Icmpv6TypeMatchEntryBuilder setIcmpv6Type(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._icmpv6Type = value;
        return this;
    }

    public Icmpv6TypeMatchEntry build() {
        return new Icmpv6TypeMatchEntryImpl(this);
    }

    private static final class Icmpv6TypeMatchEntryImpl
    implements Icmpv6TypeMatchEntry {
        private final Short _icmpv6Type;

        public Class<Icmpv6TypeMatchEntry> getImplementedInterface() {
            return Icmpv6TypeMatchEntry.class;
        }

        private Icmpv6TypeMatchEntryImpl(Icmpv6TypeMatchEntryBuilder builder) {
            this._icmpv6Type = builder.getIcmpv6Type();
        }

        @Override
        public Short getIcmpv6Type() {
            return this._icmpv6Type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._icmpv6Type == null ? 0 : this._icmpv6Type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Icmpv6TypeMatchEntryImpl other = (Icmpv6TypeMatchEntryImpl)obj;
            return !(this._icmpv6Type == null ? other._icmpv6Type != null : !this._icmpv6Type.equals(other._icmpv6Type));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Icmpv6TypeMatchEntry [_icmpv6Type=");
            builder.append(this._icmpv6Type);
            builder.append("]");
            return builder.toString();
        }
    }
}

