/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntry;

public class Icmpv4TypeMatchEntryBuilder {
    private Short _icmpv4Type;

    public Short getIcmpv4Type() {
        return this._icmpv4Type;
    }

    public Icmpv4TypeMatchEntryBuilder setIcmpv4Type(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._icmpv4Type = value;
        return this;
    }

    public Icmpv4TypeMatchEntry build() {
        return new Icmpv4TypeMatchEntryImpl(this);
    }

    private static final class Icmpv4TypeMatchEntryImpl
    implements Icmpv4TypeMatchEntry {
        private final Short _icmpv4Type;

        public Class<Icmpv4TypeMatchEntry> getImplementedInterface() {
            return Icmpv4TypeMatchEntry.class;
        }

        private Icmpv4TypeMatchEntryImpl(Icmpv4TypeMatchEntryBuilder builder) {
            this._icmpv4Type = builder.getIcmpv4Type();
        }

        @Override
        public Short getIcmpv4Type() {
            return this._icmpv4Type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._icmpv4Type == null ? 0 : this._icmpv4Type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Icmpv4TypeMatchEntryImpl other = (Icmpv4TypeMatchEntryImpl)obj;
            return !(this._icmpv4Type == null ? other._icmpv4Type != null : !this._icmpv4Type.equals(other._icmpv4Type));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Icmpv4TypeMatchEntry [_icmpv4Type=");
            builder.append(this._icmpv4Type);
            builder.append("]");
            return builder.toString();
        }
    }
}

