/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.GroupIdAction;

public class GroupIdActionBuilder {
    private Long _groupId;

    public Long getGroupId() {
        return this._groupId;
    }

    public GroupIdActionBuilder setGroupId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._groupId = value;
        return this;
    }

    public GroupIdAction build() {
        return new GroupIdActionImpl(this);
    }

    private static final class GroupIdActionImpl
    implements GroupIdAction {
        private final Long _groupId;

        public Class<GroupIdAction> getImplementedInterface() {
            return GroupIdAction.class;
        }

        private GroupIdActionImpl(GroupIdActionBuilder builder) {
            this._groupId = builder.getGroupId();
        }

        @Override
        public Long getGroupId() {
            return this._groupId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupIdActionImpl other = (GroupIdActionImpl)obj;
            return !(this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupIdAction [_groupId=");
            builder.append(this._groupId);
            builder.append("]");
            return builder.toString();
        }
    }
}

