/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterError;

public class ExperimenterErrorBuilder {
    private Integer _expType;
    private Long _experimenter;

    public Integer getExpType() {
        return this._expType;
    }

    public Long getExperimenter() {
        return this._experimenter;
    }

    public ExperimenterErrorBuilder setExpType(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._expType = value;
        return this;
    }

    public ExperimenterErrorBuilder setExperimenter(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._experimenter = value;
        return this;
    }

    public ExperimenterError build() {
        return new ExperimenterErrorImpl(this);
    }

    private static final class ExperimenterErrorImpl
    implements ExperimenterError {
        private final Integer _expType;
        private final Long _experimenter;

        public Class<ExperimenterError> getImplementedInterface() {
            return ExperimenterError.class;
        }

        private ExperimenterErrorImpl(ExperimenterErrorBuilder builder) {
            this._expType = builder.getExpType();
            this._experimenter = builder.getExperimenter();
        }

        @Override
        public Integer getExpType() {
            return this._expType;
        }

        @Override
        public Long getExperimenter() {
            return this._experimenter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._expType == null ? 0 : this._expType.hashCode());
            result = 31 * result + (this._experimenter == null ? 0 : this._experimenter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExperimenterErrorImpl other = (ExperimenterErrorImpl)obj;
            if (this._expType == null ? other._expType != null : !this._expType.equals(other._expType)) {
                return false;
            }
            return !(this._experimenter == null ? other._experimenter != null : !this._experimenter.equals(other._experimenter));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ExperimenterError [_expType=");
            builder.append(this._expType);
            builder.append(", _experimenter=");
            builder.append(this._experimenter);
            builder.append("]");
            return builder.toString();
        }
    }
}

