/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntry;

public class EcnMatchEntryBuilder {
    private Short _ecn;

    public Short getEcn() {
        return this._ecn;
    }

    public EcnMatchEntryBuilder setEcn(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ecn = value;
        return this;
    }

    public EcnMatchEntry build() {
        return new EcnMatchEntryImpl(this);
    }

    private static final class EcnMatchEntryImpl
    implements EcnMatchEntry {
        private final Short _ecn;

        public Class<EcnMatchEntry> getImplementedInterface() {
            return EcnMatchEntry.class;
        }

        private EcnMatchEntryImpl(EcnMatchEntryBuilder builder) {
            this._ecn = builder.getEcn();
        }

        @Override
        public Short getEcn() {
            return this._ecn;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ecn == null ? 0 : this._ecn.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EcnMatchEntryImpl other = (EcnMatchEntryImpl)obj;
            return !(this._ecn == null ? other._ecn != null : !this._ecn.equals(other._ecn));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EcnMatchEntry [_ecn=");
            builder.append(this._ecn);
            builder.append("]");
            return builder.toString();
        }
    }
}

