/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.connectionmanager.northbound;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.connectionmanager.northbound.Nodes;
import org.opendaylight.controller.northbound.commons.exception.NotAcceptableException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;

@Path(value="/")
public class ConnectionManagerNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private IConnectionManager getConnectionManager() {
        return (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
    }

    @Path(value="/nodes")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Nodes.class)
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=406, condition="Invalid Controller IP Address passed."), @ResponseCode(code=503, condition="Connection Manager Service not available")})
    public Nodes getNodes(@DefaultValue(value="") @QueryParam(value="controller") String controllerAddress) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container");
        }
        IConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager == null) {
            throw new ServiceUnavailableException("IConnectionManager not available.");
        }
        if (controllerAddress != null && controllerAddress.trim().length() > 0 && !NetUtils.isIPv4AddressValid((String)controllerAddress)) {
            throw new NotAcceptableException("Invalid ip address " + controllerAddress);
        }
        Set nodeSet = null;
        if (controllerAddress != null) {
            try {
                nodeSet = connectionManager.getNodes(InetAddress.getByName(controllerAddress));
            }
            catch (UnknownHostException e) {
                throw new NotAcceptableException("Invalid ip address " + controllerAddress);
            }
        } else {
            nodeSet = connectionManager.getLocalNodes();
        }
        return new Nodes(nodeSet);
    }

    @Path(value="/node/{nodeId}/address/{ipAddress}/port/{port}/")
    @PUT
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Node.class)
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="Could not connect to the Node with the specified parameters"), @ResponseCode(code=406, condition="Invalid IP Address or Port parameter passed."), @ResponseCode(code=503, condition="Connection Manager Service not available")})
    public Node connect(@PathParam(value="nodeId") String nodeId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="port") String port) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container");
        }
        IConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager == null) {
            throw new ServiceUnavailableException("IConnectionManager not available.");
        }
        if (!NetUtils.isIPv4AddressValid((String)ipAddress)) {
            throw new NotAcceptableException("Invalid ip address " + ipAddress);
        }
        try {
            Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new NotAcceptableException("Invalid Layer4 Port " + port);
        }
        HashMap<ConnectionConstants, String> params = new HashMap<ConnectionConstants, String>();
        params.put(ConnectionConstants.ADDRESS, ipAddress);
        params.put(ConnectionConstants.PORT, port);
        Node node = null;
        try {
            node = connectionManager.connect(nodeId, params);
            if (node == null) {
                throw new ResourceNotFoundException("Failed to connect to Node at " + ipAddress + ":" + port);
            }
            return node;
        }
        catch (Exception e) {
            throw new ResourceNotFoundException("Failed to connect to Node with Exception " + e.getMessage());
        }
    }

    @Path(value="/node/{nodeType}/{nodeId}/address/{ipAddress}/port/{port}/")
    @PUT
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Node.class)
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="Could not connect to the Node with the specified parameters"), @ResponseCode(code=406, condition="Invalid IP Address or Port parameter passed."), @ResponseCode(code=503, condition="Connection Manager Service not available")})
    public Node connect(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="port") String port) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container");
        }
        IConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager == null) {
            throw new ServiceUnavailableException("IConnectionManager not available.");
        }
        if (!NetUtils.isIPv4AddressValid((String)ipAddress)) {
            throw new NotAcceptableException("Invalid ip address " + ipAddress);
        }
        try {
            Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new NotAcceptableException("Invalid Layer4 Port " + port);
        }
        HashMap<ConnectionConstants, String> params = new HashMap<ConnectionConstants, String>();
        params.put(ConnectionConstants.ADDRESS, ipAddress);
        params.put(ConnectionConstants.PORT, port);
        Node node = null;
        try {
            node = connectionManager.connect(nodeType, nodeId, params);
            if (node == null) {
                throw new ResourceNotFoundException("Failed to connect to Node at " + ipAddress + ":" + port);
            }
            return node;
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
    }

    @Path(value="/node/{nodeType}/{nodeId}/")
    @DELETE
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Response.class)
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=200, condition="Node disconnected successfully"), @ResponseCode(code=404, condition="Could not find a connection with the specified Node identifier"), @ResponseCode(code=503, condition="Connection Manager Service not available")})
    public Response disconnect(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container");
        }
        IConnectionManager connectionManager = this.getConnectionManager();
        if (connectionManager == null) {
            throw new ServiceUnavailableException("IConnectionManager not available.");
        }
        try {
            Node node = Node.fromString((String)nodeType, (String)nodeId);
            Status status = connectionManager.disconnect(node);
            if (status.isSuccess()) {
                return Response.ok().build();
            }
            return NorthboundUtils.getResponse((Status)status);
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
    }
}

