/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.usermanager;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.sal.authorization.AuthResultEnum;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.usermanager.AuthResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class UserConfig
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(UserConfig.class);
    private static final boolean strongPasswordCheck = Boolean.getBoolean("enableStrongPasswordCheck");
    private static final String DIGEST_ALGORITHM = "SHA-384";
    private static final String BAD_PASSWORD = "Bad Password";
    private static final int USERNAME_MAXLENGTH = 32;
    protected static final String PASSWORD_REGEX = "(?=.*[^a-zA-Z0-9])(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,256}$";
    private static final Pattern INVALID_USERNAME_CHARACTERS = Pattern.compile("([/\\s\\.\\?#%;\\\\]+)");
    private static MessageDigest oneWayFunction;
    private static SecureRandom randomGenerator;
    @XmlElement
    protected String user;
    @XmlElement
    protected List<String> roles;
    @XmlElement
    private String password;
    private byte[] salt;

    public UserConfig() {
    }

    public UserConfig(String user, String password, List<String> roles) {
        this.user = user;
        if (this.validateClearTextPassword(password).isSuccess()) {
            this.salt = BitBufferHelper.toByteArray((Number)randomGenerator.nextLong());
            this.password = UserConfig.hash(this.salt, password);
        } else {
            this.salt = null;
            this.password = BAD_PASSWORD;
        }
        this.roles = roles == null ? Collections.emptyList() : new ArrayList<String>(roles);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserConfig other = (UserConfig)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "UserConfig[user=" + this.user + ", password=" + this.password + ", roles=" + this.roles + "]";
    }

    public Status validate() {
        Status validCheck = this.validateUsername();
        if (validCheck.isSuccess()) {
            Status status = validCheck = !this.password.equals(BAD_PASSWORD) ? new Status(StatusCode.SUCCESS) : new Status(StatusCode.BADREQUEST, "Password should be 8 to 256 characters long, contain both upper and lower case letters, at least one number and at least one non alphanumeric character");
        }
        if (validCheck.isSuccess()) {
            validCheck = this.validateRoles();
        }
        return validCheck;
    }

    protected Status validateUsername() {
        if (this.user == null || this.user.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Username cannot be empty");
        }
        Matcher mUser = INVALID_USERNAME_CHARACTERS.matcher(this.user);
        if (this.user.length() > 32 || mUser.find()) {
            return new Status(StatusCode.BADREQUEST, "Username can have 1-32 non-whitespace alphanumeric characters and any special characters except ./#%;?\\");
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateClearTextPassword(String password) {
        if (password == null || password.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Password cannot be empty");
        }
        if (strongPasswordCheck && !password.matches(PASSWORD_REGEX)) {
            return new Status(StatusCode.BADREQUEST, "Password should be 8 to 256 characters long, contain both upper and lower case letters, at least one number and at least one non alphanumeric character");
        }
        return new Status(StatusCode.SUCCESS);
    }

    protected Status validateRoles() {
        if (this.roles == null || this.roles.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "No role specified");
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status update(String currentPassword, String newPassword, List<String> newRoles) {
        if (!this.password.equals(UserConfig.hash(this.salt, currentPassword))) {
            return new Status(StatusCode.BADREQUEST, "Current password is incorrect");
        }
        UserConfig proposed = new UserConfig();
        proposed.user = this.user;
        proposed.password = newPassword == null ? this.password : UserConfig.hash(this.salt, newPassword);
        proposed.roles = newRoles == null ? this.roles : newRoles;
        Status status = proposed.validate();
        if (!status.isSuccess()) {
            return status;
        }
        this.user = proposed.user;
        this.password = proposed.password;
        this.roles = new ArrayList<String>(proposed.roles);
        return status;
    }

    public AuthResponse authenticate(String clearTextPassword) {
        AuthResponse locResponse = new AuthResponse();
        if (this.password.equals(UserConfig.hash(this.salt, clearTextPassword))) {
            locResponse.setStatus(AuthResultEnum.AUTH_ACCEPT_LOC);
            locResponse.addData(this.getRolesString());
        } else {
            locResponse.setStatus(AuthResultEnum.AUTH_REJECT_LOC);
        }
        return locResponse;
    }

    protected String getRolesString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.roles.isEmpty()) {
            Iterator<String> iter = this.roles.iterator();
            buffer.append(iter.next());
            while (iter.hasNext()) {
                buffer.append(" ");
                buffer.append(iter.next());
            }
        }
        return buffer.toString();
    }

    private static byte[] concatenate(byte[] salt, String password) {
        byte[] messageArray = password.getBytes();
        byte[] concatenation = new byte[salt.length + password.length()];
        System.arraycopy(salt, 0, concatenation, 0, salt.length);
        System.arraycopy(messageArray, 0, concatenation, salt.length, messageArray.length);
        return concatenation;
    }

    private static String hash(byte[] salt, String message) {
        if (message == null) {
            log.warn("Password hash requested but empty or no password provided");
            return message;
        }
        if (salt == null || salt.length == 0) {
            log.warn("Password hash requested but empty or no salt provided");
            return message;
        }
        byte[] messageArray = message.getBytes();
        byte[] concatenation = new byte[salt.length + message.length()];
        System.arraycopy(salt, 0, concatenation, 0, salt.length);
        System.arraycopy(messageArray, 0, concatenation, salt.length, messageArray.length);
        oneWayFunction.reset();
        return HexEncode.bytesToHexString((byte[])oneWayFunction.digest(UserConfig.concatenate(salt, message)));
    }

    public static UserConfig getUncheckedUserConfig(String userName, String password, List<String> roles) {
        UserConfig config = new UserConfig();
        config.user = userName;
        config.salt = BitBufferHelper.toByteArray((Number)randomGenerator.nextLong());
        config.password = UserConfig.hash(config.salt, password);
        config.roles = roles;
        return config;
    }

    static {
        try {
            oneWayFunction = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(String.format("Implementation of %s digest algorithm not found: %s", DIGEST_ALGORITHM, e.getMessage()));
        }
        randomGenerator = new SecureRandom(BitBufferHelper.toByteArray((Number)System.currentTimeMillis()));
    }
}

