/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.usermanager;

import java.io.Serializable;
import org.opendaylight.controller.configuration.ConfigurationObject;

public class ServerConfig
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String ip;
    private String secret;
    private String protocol;

    public ServerConfig() {
    }

    public ServerConfig(String ip, String secret, String protocol) {
        this.ip = ip;
        this.secret = secret;
        this.protocol = protocol;
    }

    public String getAddress() {
        return this.ip;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerConfig other = (ServerConfig)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        return !(this.secret == null ? other.secret != null : !this.secret.equals(other.secret));
    }

    public boolean isValid() {
        return this.ip != null && !this.ip.isEmpty() && this.secret != null && !this.secret.isEmpty();
    }
}

