/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.usermanager.ODLUserLevel;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthenticatedUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> userRoles = null;
    private Date accessDate = new Date();

    public AuthenticatedUser(String name) {
    }

    public void setRoleList(List<String> roleList) {
        this.userRoles = roleList;
    }

    public void setRoleList(String[] roleArray) {
        this.userRoles = new ArrayList<String>(roleArray.length);
        for (String role : roleArray) {
            String target = role.trim();
            if (target.isEmpty()) continue;
            this.userRoles.add(target);
        }
    }

    public List<String> getUserRoles() {
        return this.userRoles;
    }

    public void addUserRole(String string) {
        this.userRoles.add(string);
    }

    public String getAccessDate() {
        return this.accessDate.toString();
    }

    public List<GrantedAuthority> getGrantedAuthorities(UserLevel usrLvl) {
        ArrayList<GrantedAuthority> roles = new ArrayList<GrantedAuthority>();
        roles.add((GrantedAuthority)new SimpleGrantedAuthority(new ODLUserLevel(usrLvl).getAuthority()));
        return roles;
    }
}

