/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connect.netconf;

import com.google.common.base.Optional;
import java.util.Set;
import org.opendaylight.controller.sal.connect.netconf.NetconfDevice;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.ImmutableCompositeNode;
import org.opendaylight.yangtools.yang.data.impl.util.CompositeNodeBuilder;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;

class NetconfRemoteSchemaSourceProvider
implements SchemaSourceProvider<String> {
    public static final QName IETF_NETCONF_MONITORING = QName.create((String)"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring", (String)"2010-10-04", (String)"ietf-netconf-monitoring");
    public static final QName GET_SCHEMA_QNAME = QName.create((QName)IETF_NETCONF_MONITORING, (String)"get-schema");
    public static final QName GET_DATA_QNAME = QName.create((QName)IETF_NETCONF_MONITORING, (String)"data");
    NetconfDevice device;

    public NetconfRemoteSchemaSourceProvider(NetconfDevice device) {
        this.device = device;
    }

    public Optional<String> getSchemaSource(String moduleName, Optional<String> revision) {
        String schemaBody;
        CompositeNodeBuilder request = ImmutableCompositeNode.builder();
        ((CompositeNodeBuilder)request.setQName(GET_SCHEMA_QNAME)).addLeaf("format", "yang").addLeaf("identifier", moduleName);
        if (revision.isPresent()) {
            request.addLeaf("version", (String)revision.get());
        }
        this.device.logger.trace("Loading YANG schema source for {}:{}", (Object)moduleName, revision);
        RpcResult<CompositeNode> schemaReply = this.device.invokeRpc(GET_SCHEMA_QNAME, (CompositeNode)request.toInstance());
        if (schemaReply.isSuccessful() && (schemaBody = this.getSchemaFromRpc((CompositeNode)schemaReply.getResult())) != null) {
            this.device.logger.trace("YANG Schema successfully retrieved from remote for {}:{}", (Object)moduleName, revision);
            return Optional.of((Object)schemaBody);
        }
        this.device.logger.warn("YANG shcema was not successfully retrieved.");
        return Optional.absent();
    }

    private String getSchemaFromRpc(CompositeNode result) {
        if (result == null) {
            return null;
        }
        SimpleNode simpleNode = result.getFirstSimpleByName(GET_DATA_QNAME.withoutRevision());
        Object potential = simpleNode.getValue();
        if (potential instanceof String) {
            return (String)potential;
        }
        return null;
    }

    public static final boolean isSupportedFor(Set<QName> capabilities) {
        return capabilities.contains(IETF_NETCONF_MONITORING);
    }
}

