/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connect.netconf;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.ImmutableCompositeNode;
import org.opendaylight.yangtools.yang.data.impl.NodeUtils;
import org.opendaylight.yangtools.yang.data.impl.SimpleNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlDocumentUtils;
import org.opendaylight.yangtools.yang.data.impl.util.CompositeNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetconfMapping {
    public static final URI NETCONF_URI = new Functions.Function0<URI>(){

        public URI apply() {
            URI _create = URI.create("urn:ietf:params:xml:ns:netconf:base:1.0");
            return _create;
        }
    }.apply();
    public static final String NETCONF_MONITORING_URI = "urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring";
    public static final URI NETCONF_NOTIFICATION_URI = new Functions.Function0<URI>(){

        public URI apply() {
            URI _create = URI.create("urn:ietf:params:xml:ns:netconf:notification:1.0");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((URI)NETCONF_URI, null, (String)"netconf");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_RPC_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"rpc");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_GET_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"get");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_FILTER_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"filter");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_TYPE_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"type");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_GET_CONFIG_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"get-config");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_EDIT_CONFIG_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"edit-config");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_DELETE_CONFIG_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"delete-config");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_ACTION_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"action");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_COMMIT_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"commit");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_CONFIG_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"config");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_SOURCE_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"source");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_TARGET_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"target");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_CANDIDATE_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"candidate");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_RUNNING_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"running");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_RPC_REPLY_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"rpc-reply");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_OK_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"ok");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_DATA_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((QName)NETCONF_QNAME, (String)"data");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_CREATE_SUBSCRIPTION_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((URI)NETCONF_NOTIFICATION_URI, null, (String)"create-subscription");
            return _create;
        }
    }.apply();
    public static final QName NETCONF_CANCEL_SUBSCRIPTION_QNAME = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((URI)NETCONF_NOTIFICATION_URI, null, (String)"cancel-subscription");
            return _create;
        }
    }.apply();
    public static final QName IETF_NETCONF_MONITORING_MODULE = new Functions.Function0<QName>(){

        public QName apply() {
            QName _create = QName.create((String)NetconfMapping.NETCONF_MONITORING_URI, (String)"2010-10-04", (String)"ietf-netconf-monitoring");
            return _create;
        }
    }.apply();
    private static List<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>> RUNNING = new Functions.Function0<List<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>>>(){

        public List<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>> apply() {
            SimpleNodeTOImpl _simpleNodeTOImpl = new SimpleNodeTOImpl(NETCONF_RUNNING_QNAME, null, null);
            List<SimpleNodeTOImpl> _singletonList = Collections.singletonList(_simpleNodeTOImpl);
            return _singletonList;
        }
    }.apply();
    public static final CompositeNodeTOImpl CONFIG_SOURCE_RUNNING = new Functions.Function0<CompositeNodeTOImpl>(){

        public CompositeNodeTOImpl apply() {
            CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(NETCONF_SOURCE_QNAME, null, RUNNING);
            return _compositeNodeTOImpl;
        }
    }.apply();
    private static final AtomicInteger messageId = new Functions.Function0<AtomicInteger>(){

        public AtomicInteger apply() {
            AtomicInteger _atomicInteger = new AtomicInteger(0);
            return _atomicInteger;
        }
    }.apply();

    public static org.opendaylight.yangtools.yang.data.api.Node<? extends Object> toFilterStructure(InstanceIdentifier identifier) {
        org.opendaylight.yangtools.yang.data.api.Node<? extends Object> previous = null;
        List _path = identifier.getPath();
        boolean _isEmpty = _path.isEmpty();
        if (_isEmpty) {
            return null;
        }
        List _path_1 = identifier.getPath();
        List _reverseView = ListExtensions.reverseView((List)_path_1);
        for (InstanceIdentifier.PathArgument component : _reverseView) {
            org.opendaylight.yangtools.yang.data.api.Node<? extends Object> current;
            previous = current = NetconfMapping.toNode(component, previous);
        }
        return NetconfMapping.filter("subtree", previous);
    }

    protected static org.opendaylight.yangtools.yang.data.api.Node<? extends Object> _toNode(InstanceIdentifier.NodeIdentifierWithPredicates argument, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> node) {
        ArrayList<SimpleNodeTOImpl> _arrayList;
        ArrayList<SimpleNodeTOImpl> list = _arrayList = new ArrayList<SimpleNodeTOImpl>();
        Map _keyValues = argument.getKeyValues();
        Set _entrySet = _keyValues.entrySet();
        for (Map.Entry arg : _entrySet) {
            QName _key = (QName)arg.getKey();
            Object _value = arg.getValue();
            SimpleNodeTOImpl _simpleNodeTOImpl = new SimpleNodeTOImpl(_key, null, _value);
            list.add(_simpleNodeTOImpl);
        }
        QName _nodeType = argument.getNodeType();
        CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(_nodeType, null, list);
        return _compositeNodeTOImpl;
    }

    protected static org.opendaylight.yangtools.yang.data.api.Node<? extends Object> _toNode(InstanceIdentifier.PathArgument argument, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> node) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(node, null);
        if (_notEquals) {
            QName _nodeType = argument.getNodeType();
            List<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>> _singletonList = Collections.singletonList(node);
            CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(_nodeType, null, _singletonList);
            return _compositeNodeTOImpl;
        }
        QName _nodeType_1 = argument.getNodeType();
        SimpleNodeTOImpl _simpleNodeTOImpl = new SimpleNodeTOImpl(_nodeType_1, null, null);
        return _simpleNodeTOImpl;
    }

    public static CompositeNode toCompositeNode(NetconfMessage message, Optional<SchemaContext> ctx) {
        return null;
    }

    public static NetconfMessage toRpcMessage(QName rpc, CompositeNode node, Optional<SchemaContext> ctx) {
        CompositeNode _flattenInput = NetconfMapping.flattenInput(node);
        CompositeNodeTOImpl rpcPayload = NetconfMapping.wrap(NETCONF_RPC_QNAME, (org.opendaylight.yangtools.yang.data.api.Node<? extends Object>)_flattenInput);
        Document w3cPayload = NodeUtils.buildShadowDomTree((CompositeNode)rpcPayload);
        Element _documentElement = w3cPayload.getDocumentElement();
        int _andIncrement = messageId.getAndIncrement();
        String _plus = "m-" + Integer.valueOf(_andIncrement);
        _documentElement.setAttribute("message-id", _plus);
        NetconfMessage _netconfMessage = new NetconfMessage(w3cPayload);
        return _netconfMessage;
    }

    public static CompositeNode flattenInput(CompositeNode node) {
        CompositeNode _xblockexpression = null;
        QName _nodeType = node.getNodeType();
        final QName inputQName = QName.create((QName)_nodeType, (String)"input");
        CompositeNode input = node.getFirstCompositeByName(inputQName);
        boolean _equals = Objects.equal((Object)input, null);
        if (_equals) {
            return node;
        }
        CompositeNode _xifexpression = null;
        if (input instanceof CompositeNode) {
            ImmutableList.Builder _builder = ImmutableList.builder();
            List _children = input.getChildren();
            ImmutableList.Builder _addAll = _builder.addAll((Iterable)_children);
            List _children_1 = node.getChildren();
            Functions.Function1<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>, Boolean> _function = new Functions.Function1<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>, Boolean>(){

                public Boolean apply(org.opendaylight.yangtools.yang.data.api.Node<? extends Object> it) {
                    QName _nodeType = it.getNodeType();
                    boolean _notEquals = !Objects.equal((Object)_nodeType, (Object)inputQName);
                    return _notEquals;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_children_1, (Functions.Function1)_function);
            ImmutableList.Builder _addAll_1 = _addAll.addAll(_filter);
            ImmutableList nodes = _addAll_1.build();
            QName _nodeType_1 = node.getNodeType();
            return ImmutableCompositeNode.create((QName)_nodeType_1, (List)nodes);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static RpcResult<CompositeNode> toRpcResult(NetconfMessage message, final QName rpc, Optional<SchemaContext> context) {
        CompositeNode rawRpc = null;
        boolean _isPresent = context.isPresent();
        if (_isPresent) {
            boolean _isDataRetrievalReply = NetconfMapping.isDataRetrievalReply(rpc);
            if (_isDataRetrievalReply) {
                Document _document = message.getDocument();
                Element xmlData = NetconfMapping.getDataSubtree(_document);
                SchemaContext _get = (SchemaContext)context.get();
                Set _dataDefinitions = _get.getDataDefinitions();
                Optional _of = Optional.of((Object)_dataDefinitions);
                List dataNodes = XmlDocumentUtils.toDomNodes((Element)xmlData, (Optional)_of);
                CompositeNodeBuilder it = ImmutableCompositeNode.builder();
                it.setQName(NETCONF_RPC_REPLY_QNAME);
                ImmutableCompositeNode _create = ImmutableCompositeNode.create((QName)NETCONF_DATA_QNAME, (List)dataNodes);
                it.add((org.opendaylight.yangtools.yang.data.api.Node)_create);
                ImmutableCompositeNode _instance = (ImmutableCompositeNode)it.toInstance();
                rawRpc = _instance;
            } else {
                SchemaContext _get_1 = (SchemaContext)context.get();
                Set _operations = _get_1.getOperations();
                Functions.Function1<RpcDefinition, Boolean> _function = new Functions.Function1<RpcDefinition, Boolean>(){

                    public Boolean apply(RpcDefinition it) {
                        QName _qName = it.getQName();
                        boolean _equals = Objects.equal((Object)_qName, (Object)rpc);
                        return _equals;
                    }
                };
                RpcDefinition rpcSchema = (RpcDefinition)IterableExtensions.findFirst((Iterable)_operations, (Functions.Function1)_function);
                Document _document_1 = message.getDocument();
                org.opendaylight.yangtools.yang.data.api.Node<? extends Object> _compositeNode = NetconfMapping.toCompositeNode(_document_1);
                rawRpc = (CompositeNode)_compositeNode;
            }
        } else {
            Document _document_2 = message.getDocument();
            org.opendaylight.yangtools.yang.data.api.Node<? extends Object> _compositeNode_1 = NetconfMapping.toCompositeNode(_document_2);
            rawRpc = (CompositeNode)_compositeNode_1;
        }
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)true, (Object)rawRpc, _emptySet);
    }

    public static Element getDataSubtree(Document doc) {
        String _string = NETCONF_URI.toString();
        NodeList _elementsByTagNameNS = doc.getElementsByTagNameNS(_string, "data");
        Node _item = _elementsByTagNameNS.item(0);
        return (Element)_item;
    }

    public static boolean isDataRetrievalReply(QName it) {
        boolean _and = false;
        URI _namespace = it.getNamespace();
        boolean _equals = Objects.equal((Object)NETCONF_URI, (Object)_namespace);
        if (!_equals) {
            _and = false;
        } else {
            String _localName_1;
            boolean _or = false;
            String _localName = it.getLocalName();
            boolean _equals_1 = Objects.equal((Object)_localName, (Object)(_localName_1 = NETCONF_GET_CONFIG_QNAME.getLocalName()));
            if (_equals_1) {
                _or = true;
            } else {
                String _localName_2 = it.getLocalName();
                String _localName_3 = NETCONF_GET_QNAME.getLocalName();
                boolean _equals_2 = Objects.equal((Object)_localName_2, (Object)_localName_3);
                _or = _equals_1 || _equals_2;
            }
            _and = _equals && _or;
        }
        return _and;
    }

    public static CompositeNodeTOImpl wrap(QName name, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> node) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(node, null);
        if (_notEquals) {
            List<org.opendaylight.yangtools.yang.data.api.Node<? extends Object>> _singletonList = Collections.singletonList(node);
            CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(name, null, _singletonList);
            return _compositeNodeTOImpl;
        }
        List _emptyList = Collections.emptyList();
        CompositeNodeTOImpl _compositeNodeTOImpl_1 = new CompositeNodeTOImpl(name, null, _emptyList);
        return _compositeNodeTOImpl_1;
    }

    public static CompositeNodeTOImpl wrap(QName name, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> additional, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> node) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(node, null);
        if (_notEquals) {
            ImmutableList _of = ImmutableList.of(additional, node);
            CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(name, null, (List)_of);
            return _compositeNodeTOImpl;
        }
        ImmutableList _of_1 = ImmutableList.of(additional);
        CompositeNodeTOImpl _compositeNodeTOImpl_1 = new CompositeNodeTOImpl(name, null, (List)_of_1);
        return _compositeNodeTOImpl_1;
    }

    public static ImmutableCompositeNode filter(String type, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> node) {
        boolean _notEquals;
        CompositeNodeBuilder it = ImmutableCompositeNode.builder();
        it.setQName(NETCONF_FILTER_QNAME);
        it.setAttribute(NETCONF_TYPE_QNAME, type);
        boolean bl = _notEquals = !Objects.equal(node, null);
        if (_notEquals) {
            CompositeNodeBuilder _add = it.add(node);
            return (ImmutableCompositeNode)_add.toInstance();
        }
        return (ImmutableCompositeNode)it.toInstance();
    }

    public static org.opendaylight.yangtools.yang.data.api.Node<? extends Object> toCompositeNode(Document document) {
        org.opendaylight.yangtools.yang.data.api.Node _domNode = XmlDocumentUtils.toDomNode((Document)document);
        return _domNode;
    }

    public static void checkValidReply(NetconfMessage input, NetconfMessage output) {
        Document _document = input.getDocument();
        Element _documentElement = _document.getDocumentElement();
        String inputMsgId = _documentElement.getAttribute("message-id");
        Document _document_1 = output.getDocument();
        Element _documentElement_1 = _document_1.getDocumentElement();
        String outputMsgId = _documentElement_1.getAttribute("message-id");
        boolean _equals = Objects.equal((Object)inputMsgId, (Object)outputMsgId);
        Preconditions.checkState((boolean)_equals, (Object)"Rpc request and reply message IDs must be same.");
    }

    public static org.opendaylight.yangtools.yang.data.api.Node<? extends Object> toNode(InstanceIdentifier.PathArgument argument, org.opendaylight.yangtools.yang.data.api.Node<? extends Object> node) {
        if (argument instanceof InstanceIdentifier.NodeIdentifierWithPredicates) {
            return NetconfMapping._toNode((InstanceIdentifier.NodeIdentifierWithPredicates)argument, node);
        }
        if (argument != null) {
            return NetconfMapping._toNode(argument, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument, node).toString());
    }
}

