/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connect.netconf;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.sal.connect.netconf.NetconfDevice;
import org.opendaylight.controller.sal.connect.netconf.NetconfMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.ImmutableCompositeNode;
import org.opendaylight.yangtools.yang.data.impl.util.CompositeNodeBuilder;

public class NetconfDeviceTwoPhaseCommitTransaction
implements DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> {
    private NetconfDevice device;
    private final DataModification<InstanceIdentifier, CompositeNode> modification;
    private boolean candidateSupported = true;

    public NetconfDeviceTwoPhaseCommitTransaction(NetconfDevice device, DataModification<InstanceIdentifier, CompositeNode> modification) {
        this.device = device;
        this.modification = modification;
    }

    public void prepare() {
        for (InstanceIdentifier instanceIdentifier : this.modification.getRemovedConfigurationData()) {
            this.sendRemove(instanceIdentifier);
        }
        for (Map.Entry entry : this.modification.getUpdatedConfigurationData().entrySet()) {
            this.sendMerge((InstanceIdentifier)entry.getKey(), (CompositeNode)entry.getValue());
        }
    }

    private void sendMerge(InstanceIdentifier key, CompositeNode value) {
        this.sendEditRpc(this.createEditStructure(key, (Optional<String>)Optional.absent(), (Optional<CompositeNode>)Optional.of((Object)value)));
    }

    private void sendRemove(InstanceIdentifier toRemove) {
        this.sendEditRpc(this.createEditStructure(toRemove, (Optional<String>)Optional.of((Object)"remove"), (Optional<CompositeNode>)Optional.absent()));
    }

    private void sendEditRpc(CompositeNode editStructure) {
        CompositeNodeBuilder<ImmutableCompositeNode> builder = this.configurationRpcBuilder();
        builder.setQName(NetconfMapping.NETCONF_EDIT_CONFIG_QNAME);
        builder.add((Node)editStructure);
        RpcResult<CompositeNode> rpcResult = this.device.invokeRpc(NetconfMapping.NETCONF_EDIT_CONFIG_QNAME, (CompositeNode)builder.toInstance());
        Preconditions.checkState((boolean)rpcResult.isSuccessful(), (Object)"Rpc Result was unsuccessful");
    }

    private CompositeNodeBuilder<ImmutableCompositeNode> configurationRpcBuilder() {
        CompositeNodeBuilder ret = ImmutableCompositeNode.builder();
        ImmutableCompositeNode targetNode = this.candidateSupported ? ImmutableCompositeNode.create((QName)NetconfMapping.NETCONF_CANDIDATE_QNAME, (List)ImmutableList.of()) : ImmutableCompositeNode.create((QName)NetconfMapping.NETCONF_RUNNING_QNAME, (List)ImmutableList.of());
        ImmutableCompositeNode targetWrapperNode = ImmutableCompositeNode.create((QName)NetconfMapping.NETCONF_TARGET_QNAME, (List)ImmutableList.of((Object)targetNode));
        ret.add((Node)targetWrapperNode);
        return ret;
    }

    private CompositeNode createEditStructure(InstanceIdentifier dataPath, Optional<String> action, Optional<CompositeNode> lastChildOverride) {
        List path = dataPath.getPath();
        List reversed = Lists.reverse((List)path);
        CompositeNode previous = null;
        boolean isLast = true;
        for (InstanceIdentifier.PathArgument arg : reversed) {
            CompositeNodeBuilder builder = ImmutableCompositeNode.builder();
            builder.setQName(arg.getNodeType());
            Map predicates = Collections.emptyMap();
            if (arg instanceof InstanceIdentifier.NodeIdentifierWithPredicates) {
                predicates = ((InstanceIdentifier.NodeIdentifierWithPredicates)arg).getKeyValues();
            }
            for (Map.Entry entry : predicates.entrySet()) {
                builder.addLeaf((QName)entry.getKey(), entry.getValue());
            }
            if (isLast) {
                if (action.isPresent()) {
                    builder.setAttribute(NetconfMapping.NETCONF_ACTION_QNAME, (String)action.get());
                }
                if (lastChildOverride.isPresent()) {
                    List children = ((CompositeNode)lastChildOverride.get()).getChildren();
                    for (Node child : children) {
                        if (predicates.containsKey(child.getKey())) continue;
                        builder.add(child);
                    }
                }
            } else {
                builder.add(previous);
            }
            previous = (CompositeNode)builder.toInstance();
            isLast = false;
        }
        return ImmutableCompositeNode.create((QName)NetconfMapping.NETCONF_CONFIG_QNAME, (List)ImmutableList.of(previous));
    }

    public RpcResult<Void> finish() throws IllegalStateException {
        CompositeNodeBuilder commitInput = ImmutableCompositeNode.builder();
        commitInput.setQName(NetconfMapping.NETCONF_COMMIT_QNAME);
        RpcResult<CompositeNode> rpcResult = this.device.invokeRpc(NetconfMapping.NETCONF_COMMIT_QNAME, (CompositeNode)commitInput.toInstance());
        return rpcResult;
    }

    public DataModification<InstanceIdentifier, CompositeNode> getModification() {
        return this.modification;
    }

    public RpcResult<Void> rollback() throws IllegalStateException {
        return null;
    }
}

