/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connect.netconf;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.controller.sal.connect.netconf.NetconfDevice;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceContext;

class NetconfDeviceSchemaContextProvider {
    private final NetconfDevice _device;
    private final SchemaSourceProvider<InputStream> _sourceProvider;
    private Optional<SchemaContext> _currentContext;

    public NetconfDevice getDevice() {
        return this._device;
    }

    public SchemaSourceProvider<InputStream> getSourceProvider() {
        return this._sourceProvider;
    }

    public Optional<SchemaContext> getCurrentContext() {
        return this._currentContext;
    }

    public void setCurrentContext(Optional<SchemaContext> currentContext) {
        this._currentContext = currentContext;
    }

    public NetconfDeviceSchemaContextProvider(NetconfDevice device, SchemaSourceProvider<InputStream> sourceProvider) {
        Optional _absent;
        this._device = device;
        this._sourceProvider = sourceProvider;
        this._currentContext = _absent = Optional.absent();
    }

    public void createContextFromCapabilities(Iterable<QName> capabilities) {
        boolean _not_1;
        boolean _not;
        SchemaSourceProvider<InputStream> _sourceProvider = this.getSourceProvider();
        YangSourceContext sourceContext = YangSourceContext.createFrom(capabilities, _sourceProvider);
        ImmutableSet _missingSources = sourceContext.getMissingSources();
        boolean _isEmpty = _missingSources.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            NetconfDevice _device = this.getDevice();
            ImmutableSet _missingSources_1 = sourceContext.getMissingSources();
            _device.logger.warn("Sources for following models are missing {}", (Object)_missingSources_1);
        }
        NetconfDevice _device_1 = this.getDevice();
        ImmutableSet _validSources = sourceContext.getValidSources();
        _device_1.logger.debug("Trying to create schema context from {}", (Object)_validSources);
        List modelsToParse = YangSourceContext.getValidInputStreams((YangSourceContext)sourceContext);
        ImmutableSet _validSources_1 = sourceContext.getValidSources();
        boolean _isEmpty_1 = _validSources_1.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            SchemaContext schemaContext = this.tryToCreateContext(modelsToParse);
            Optional _fromNullable = Optional.fromNullable((Object)schemaContext);
            this.setCurrentContext((Optional<SchemaContext>)_fromNullable);
        } else {
            Optional _absent = Optional.absent();
            this.setCurrentContext((Optional<SchemaContext>)_absent);
        }
        Optional<SchemaContext> _currentContext = this.getCurrentContext();
        boolean _isPresent = _currentContext.isPresent();
        if (_isPresent) {
            NetconfDevice _device_2 = this.getDevice();
            _device_2.logger.debug("Schema context successfully created.");
        }
    }

    public SchemaContext tryToCreateContext(List<InputStream> modelsToParse) {
        YangParserImpl _yangParserImpl;
        YangParserImpl parser = _yangParserImpl = new YangParserImpl();
        try {
            Set models = parser.parseYangModelsFromStreams(modelsToParse);
            SchemaContext result = parser.resolveSchemaContext(models);
            return result;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                NetconfDevice _device = this.getDevice();
                _device.logger.debug("Error occured during parsing YANG schemas", (Throwable)e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

