/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connect.netconf;

import com.google.common.base.Objects;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.client.NetconfClientSessionListener;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.sal.connect.netconf.NetconfDevice;
import org.opendaylight.controller.sal.connect.netconf.NetconfMapping;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionInstance;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.w3c.dom.Document;

class NetconfDeviceListener
extends NetconfClientSessionListener {
    private final NetconfDevice device;
    private final EventExecutor eventExecutor;
    private Promise<NetconfMessage> messagePromise;
    private ConcurrentMap<String, Promise<NetconfMessage>> promisedMessages;
    private final ReentrantLock promiseLock = new ReentrantLock();

    public NetconfDeviceListener(NetconfDevice device, EventExecutor eventExecutor) {
        this.device = device;
        this.eventExecutor = eventExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(NetconfClientSession session, NetconfMessage message) {
        if (this.isNotification(message)) {
            this.onNotification(session, message);
        } else {
            try {
                boolean _notEquals;
                this.promiseLock.lock();
                boolean bl = _notEquals = !Objects.equal(this.messagePromise, null);
                if (_notEquals) {
                    this.device.logger.debug("Setting promised reply {} with message {}", this.messagePromise, (Object)message);
                    this.messagePromise.setSuccess((Object)message);
                    this.messagePromise = null;
                }
            }
            finally {
                this.promiseLock.unlock();
            }
        }
    }

    public void onNotification(NetconfClientSession session, NetconfMessage message) {
        CompositeNode domNotification;
        boolean _notEquals;
        this.device.logger.debug("Received NETCONF notification.", (Object)message);
        CompositeNode _notificationBody = null;
        CompositeNode _compositeNode = null;
        if (message != null) {
            _compositeNode = NetconfMapping.toCompositeNode(message, this.device.getSchemaContext());
        }
        if (_compositeNode != null) {
            _notificationBody = NetconfDeviceListener.getNotificationBody(_compositeNode);
        }
        boolean bl = _notEquals = !Objects.equal((Object)(domNotification = _notificationBody), null);
        if (_notEquals) {
            MountProvisionInstance _mountInstance = null;
            if (this.device != null) {
                _mountInstance = this.device.getMountInstance();
            }
            if (_mountInstance != null) {
                _mountInstance.publish(domNotification);
            }
        }
    }

    private static CompositeNode getNotificationBody(CompositeNode node) {
        List _children = node.getChildren();
        for (Node child : _children) {
            if (!(child instanceof CompositeNode)) continue;
            return (CompositeNode)child;
        }
        return null;
    }

    public NetconfMessage getLastMessage(int attempts, int attemptMsDelay) throws InterruptedException {
        Promise<NetconfMessage> promise = this.promiseReply();
        this.device.logger.debug("Waiting for reply {}", promise);
        int _plus = attempts * attemptMsDelay;
        boolean messageAvailable = promise.await((long)_plus);
        if (messageAvailable) {
            try {
                return (NetconfMessage)promise.get();
            }
            catch (Throwable _e) {
                try {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
                catch (Throwable _t) {
                    if (_t instanceof ExecutionException) {
                        ExecutionException e = (ExecutionException)_t;
                        IllegalStateException _illegalStateException = new IllegalStateException(e);
                        throw _illegalStateException;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        String _plus_1 = "Unsuccessful after " + Integer.valueOf(attempts);
        String _plus_2 = _plus_1 + " attempts.";
        IllegalStateException _illegalStateException_1 = new IllegalStateException(_plus_2);
        throw _illegalStateException_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Promise<NetconfMessage> promiseReply() {
        this.device.logger.debug("Promising reply.");
        this.promiseLock.lock();
        try {
            boolean _equals = Objects.equal(this.messagePromise, null);
            if (_equals) {
                Promise _newPromise;
                this.messagePromise = _newPromise = this.eventExecutor.newPromise();
                Promise<NetconfMessage> promise = this.messagePromise;
                return promise;
            }
            Promise<NetconfMessage> promise = this.messagePromise;
            return promise;
        }
        finally {
            this.promiseLock.unlock();
        }
    }

    public boolean isNotification(NetconfMessage message) {
        Document _document = message.getDocument();
        XmlElement xmle = XmlElement.fromDomDocument((Document)_document);
        String _name = xmle.getName();
        return "notification".equals(_name);
    }
}

