/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.connect.netconf;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import io.netty.util.concurrent.EventExecutor;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.client.NetconfClient;
import org.opendaylight.controller.netconf.client.NetconfClientDispatcher;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.client.NetconfClientSessionListener;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.controller.sal.connect.netconf.InventoryUtils;
import org.opendaylight.controller.sal.connect.netconf.NetconfDeviceListener;
import org.opendaylight.controller.sal.connect.netconf.NetconfDeviceSchemaContextProvider;
import org.opendaylight.controller.sal.connect.netconf.NetconfDeviceTwoPhaseCommitTransaction;
import org.opendaylight.controller.sal.connect.netconf.NetconfMapping;
import org.opendaylight.controller.sal.connect.netconf.NetconfRemoteSchemaSourceProvider;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.core.api.RpcImplementation;
import org.opendaylight.controller.sal.core.api.data.DataBrokerService;
import org.opendaylight.controller.sal.core.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionInstance;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionService;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.ImmutableCompositeNode;
import org.opendaylight.yangtools.yang.data.impl.SimpleNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.util.CompositeNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.repo.AbstractCachingSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NetconfDevice
implements Provider,
DataReader<InstanceIdentifier, CompositeNode>,
DataCommitHandler<InstanceIdentifier, CompositeNode>,
RpcImplementation,
AutoCloseable {
    private NetconfClient client;
    private InetSocketAddress _socketAddress;
    private MountProvisionInstance _mountInstance;
    private EventExecutor _eventExecutor;
    private ExecutorService _processingExecutor;
    private InstanceIdentifier _path;
    private ReconnectStrategy _reconnectStrategy;
    private AbstractCachingSchemaSourceProvider<String, InputStream> _schemaSourceProvider;
    private NetconfDeviceSchemaContextProvider _deviceContextProvider;
    protected final Logger logger;
    private Registration<DataReader<InstanceIdentifier, CompositeNode>> operReaderReg;
    private Registration<DataReader<InstanceIdentifier, CompositeNode>> confReaderReg;
    private Registration<DataCommitHandler<InstanceIdentifier, CompositeNode>> commitHandlerReg;
    private final String name;
    private MountProvisionService mountService;
    private int messegeRetryCount = 5;
    private int messageTimeoutCount = new Functions.Function0<Integer>(){

        public Integer apply() {
            int _multiply = 5000;
            return _multiply;
        }
    }.apply();
    private Set<QName> cachedCapabilities;
    private NetconfClientDispatcher _dispatcher;
    private static final InstanceIdentifier ROOT_PATH = new Functions.Function0<InstanceIdentifier>(){

        public InstanceIdentifier apply() {
            InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder();
            InstanceIdentifier _instance = (InstanceIdentifier)_builder.toInstance();
            return _instance;
        }
    }.apply();
    private SchemaSourceProvider<InputStream> _remoteSourceProvider;
    private DataBrokerService dataBroker;

    public InetSocketAddress getSocketAddress() {
        return this._socketAddress;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this._socketAddress = socketAddress;
    }

    public MountProvisionInstance getMountInstance() {
        return this._mountInstance;
    }

    public void setMountInstance(MountProvisionInstance mountInstance) {
        this._mountInstance = mountInstance;
    }

    public EventExecutor getEventExecutor() {
        return this._eventExecutor;
    }

    public void setEventExecutor(EventExecutor eventExecutor) {
        this._eventExecutor = eventExecutor;
    }

    public ExecutorService getProcessingExecutor() {
        return this._processingExecutor;
    }

    public void setProcessingExecutor(ExecutorService processingExecutor) {
        this._processingExecutor = processingExecutor;
    }

    public InstanceIdentifier getPath() {
        return this._path;
    }

    public void setPath(InstanceIdentifier path) {
        this._path = path;
    }

    public ReconnectStrategy getReconnectStrategy() {
        return this._reconnectStrategy;
    }

    public void setReconnectStrategy(ReconnectStrategy reconnectStrategy) {
        this._reconnectStrategy = reconnectStrategy;
    }

    public AbstractCachingSchemaSourceProvider<String, InputStream> getSchemaSourceProvider() {
        return this._schemaSourceProvider;
    }

    public void setSchemaSourceProvider(AbstractCachingSchemaSourceProvider<String, InputStream> schemaSourceProvider) {
        this._schemaSourceProvider = schemaSourceProvider;
    }

    public NetconfDeviceSchemaContextProvider getDeviceContextProvider() {
        return this._deviceContextProvider;
    }

    public void setDeviceContextProvider(NetconfDeviceSchemaContextProvider deviceContextProvider) {
        this._deviceContextProvider = deviceContextProvider;
    }

    public NetconfClientDispatcher getDispatcher() {
        return this._dispatcher;
    }

    public void setDispatcher(NetconfClientDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    public SchemaSourceProvider<InputStream> getRemoteSourceProvider() {
        return this._remoteSourceProvider;
    }

    public void setRemoteSourceProvider(SchemaSourceProvider<InputStream> remoteSourceProvider) {
        this._remoteSourceProvider = remoteSourceProvider;
    }

    public NetconfDevice(String name) {
        Logger _logger;
        this.name = name;
        String _name = NetconfDevice.class.getName();
        String _plus = _name + "#";
        String _plus_1 = _plus + name;
        this.logger = _logger = LoggerFactory.getLogger((String)_plus_1);
        InstanceIdentifier.InstanceIdentifierBuilder _builder = InstanceIdentifier.builder((InstanceIdentifier)InventoryUtils.INVENTORY_PATH);
        Map<QName, String> _singletonMap = Collections.singletonMap(InventoryUtils.INVENTORY_ID, name);
        InstanceIdentifier.InstanceIdentifierBuilder _nodeWithKey = _builder.nodeWithKey(InventoryUtils.INVENTORY_NODE, _singletonMap);
        InstanceIdentifier _instance = (InstanceIdentifier)_nodeWithKey.toInstance();
        this.setPath(_instance);
    }

    public Future<Void> start() {
        boolean _notEquals_3;
        NetconfDeviceListener _netconfDeviceListener;
        NetconfClientDispatcher _dispatcher = this.getDispatcher();
        boolean _notEquals = !Objects.equal((Object)_dispatcher, null);
        Preconditions.checkState((boolean)_notEquals, (Object)"Dispatcher must be set.");
        AbstractCachingSchemaSourceProvider<String, InputStream> _schemaSourceProvider = this.getSchemaSourceProvider();
        boolean _notEquals_1 = !Objects.equal(_schemaSourceProvider, null);
        Preconditions.checkState((boolean)_notEquals_1, (Object)"Schema Source Provider must be set.");
        EventExecutor _eventExecutor = this.getEventExecutor();
        boolean _notEquals_2 = !Objects.equal((Object)_eventExecutor, null);
        Preconditions.checkState((boolean)_notEquals_2, (Object)"Event executor must be set.");
        EventExecutor _eventExecutor_1 = this.getEventExecutor();
        NetconfDeviceListener listener = _netconfDeviceListener = new NetconfDeviceListener(this, _eventExecutor_1);
        NetconfClientDispatcher _dispatcher_1 = this.getDispatcher();
        Runnable task = this.startClientTask(_dispatcher_1, listener);
        MountProvisionInstance _mountInstance = this.getMountInstance();
        boolean bl = _notEquals_3 = !Objects.equal((Object)_mountInstance, null);
        if (_notEquals_3) {
            Registration _registerCommitHandler;
            MountProvisionInstance _mountInstance_1 = this.getMountInstance();
            this.commitHandlerReg = _registerCommitHandler = _mountInstance_1.registerCommitHandler((Path)ROOT_PATH, (DataCommitHandler)this);
        }
        ExecutorService _processingExecutor = this.getProcessingExecutor();
        Future<Void> _submit = _processingExecutor.submit(task);
        return _submit;
    }

    public Optional<SchemaContext> getSchemaContext() {
        NetconfDeviceSchemaContextProvider _deviceContextProvider = this.getDeviceContextProvider();
        boolean _equals = Objects.equal((Object)_deviceContextProvider, null);
        if (_equals) {
            return Optional.absent();
        }
        NetconfDeviceSchemaContextProvider _deviceContextProvider_1 = this.getDeviceContextProvider();
        return _deviceContextProvider_1.getCurrentContext();
    }

    private Runnable startClientTask(final NetconfClientDispatcher dispatcher, final NetconfDeviceListener listener) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean _notEquals_1;
                    boolean _notEquals;
                    InetSocketAddress _socketAddress = NetconfDevice.this.getSocketAddress();
                    NetconfDevice.this.logger.info("Starting Netconf Client on: {}", (Object)_socketAddress);
                    InetSocketAddress _socketAddress_1 = NetconfDevice.this.getSocketAddress();
                    ReconnectStrategy _reconnectStrategy = NetconfDevice.this.getReconnectStrategy();
                    NetconfClient _clientFor = NetconfClient.clientFor((String)NetconfDevice.this.name, (InetSocketAddress)_socketAddress_1, (ReconnectStrategy)_reconnectStrategy, (NetconfClientDispatcher)dispatcher, (NetconfClientSessionListener)listener);
                    NetconfDevice.this.client = _clientFor;
                    Set<QName> _initialCapabilities = NetconfDevice.this.getInitialCapabilities();
                    NetconfDevice.this.logger.debug("Initial capabilities {}", _initialCapabilities);
                    NetconfRemoteSchemaSourceProvider delegate = null;
                    Set<QName> _initialCapabilities_1 = NetconfDevice.this.getInitialCapabilities();
                    boolean _isSupportedFor = NetconfRemoteSchemaSourceProvider.isSupportedFor(_initialCapabilities_1);
                    if (_isSupportedFor) {
                        NetconfRemoteSchemaSourceProvider _netconfRemoteSchemaSourceProvider;
                        delegate = _netconfRemoteSchemaSourceProvider = new NetconfRemoteSchemaSourceProvider(NetconfDevice.this);
                    } else {
                        URI _namespace;
                        String _string;
                        Set _capabilities = NetconfDevice.this.client.getCapabilities();
                        boolean _contains = _capabilities.contains(_string = (_namespace = NetconfRemoteSchemaSourceProvider.IETF_NETCONF_MONITORING.getNamespace()).toString());
                        if (_contains) {
                            NetconfRemoteSchemaSourceProvider _netconfRemoteSchemaSourceProvider_1;
                            delegate = _netconfRemoteSchemaSourceProvider_1 = new NetconfRemoteSchemaSourceProvider(NetconfDevice.this);
                        } else {
                            InetSocketAddress _socketAddress_2 = NetconfDevice.this.getSocketAddress();
                            NetconfDevice.this.logger.info("Netconf server {} does not support IETF Netconf Monitoring", (Object)_socketAddress_2);
                            SchemaSourceProvider _noopProvider = SchemaSourceProviders.noopProvider();
                            delegate = _noopProvider;
                        }
                    }
                    AbstractCachingSchemaSourceProvider<String, InputStream> _schemaSourceProvider = NetconfDevice.this.getSchemaSourceProvider();
                    SchemaSourceProvider _createInstanceFor = _schemaSourceProvider.createInstanceFor((SchemaSourceProvider)delegate);
                    NetconfDevice.this.setRemoteSourceProvider((SchemaSourceProvider<InputStream>)_createInstanceFor);
                    SchemaSourceProvider<InputStream> _remoteSourceProvider = NetconfDevice.this.getRemoteSourceProvider();
                    NetconfDeviceSchemaContextProvider _netconfDeviceSchemaContextProvider = new NetconfDeviceSchemaContextProvider(NetconfDevice.this, _remoteSourceProvider);
                    NetconfDevice.this.setDeviceContextProvider(_netconfDeviceSchemaContextProvider);
                    NetconfDeviceSchemaContextProvider _deviceContextProvider = NetconfDevice.this.getDeviceContextProvider();
                    Set<QName> _initialCapabilities_2 = NetconfDevice.this.getInitialCapabilities();
                    _deviceContextProvider.createContextFromCapabilities(_initialCapabilities_2);
                    boolean _and = false;
                    MountProvisionInstance _mountInstance = NetconfDevice.this.getMountInstance();
                    boolean bl = _notEquals = !Objects.equal((Object)_mountInstance, null);
                    if (!_notEquals) {
                        _and = false;
                    } else {
                        Optional<SchemaContext> _schemaContext = NetconfDevice.this.getSchemaContext();
                        boolean _isPresent = _schemaContext.isPresent();
                        boolean bl2 = _and = _notEquals && _isPresent;
                    }
                    if (_and) {
                        MountProvisionInstance _mountInstance_1 = NetconfDevice.this.getMountInstance();
                        Optional<SchemaContext> _schemaContext_1 = NetconfDevice.this.getSchemaContext();
                        SchemaContext _get = (SchemaContext)_schemaContext_1.get();
                        _mountInstance_1.setSchemaContext(_get);
                    }
                    NetconfDevice.this.updateDeviceState();
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    MountProvisionInstance _mountInstance_2 = NetconfDevice.this.getMountInstance();
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)_mountInstance_2, null);
                    if (!_notEquals_1) {
                        _and_2 = false;
                    } else {
                        boolean _equals = Objects.equal((Object)NetconfDevice.this.confReaderReg, null);
                        boolean bl4 = _and_2 = _notEquals_1 && _equals;
                    }
                    if (!_and_2) {
                        _and_1 = false;
                    } else {
                        boolean _equals_1 = Objects.equal((Object)NetconfDevice.this.operReaderReg, null);
                        boolean bl5 = _and_1 = _and_2 && _equals_1;
                    }
                    if (_and_1) {
                        MountProvisionInstance _mountInstance_3 = NetconfDevice.this.getMountInstance();
                        Registration _registerConfigurationReader = _mountInstance_3.registerConfigurationReader(ROOT_PATH, (DataReader)NetconfDevice.this);
                        NetconfDevice.this.confReaderReg = _registerConfigurationReader;
                        MountProvisionInstance _mountInstance_4 = NetconfDevice.this.getMountInstance();
                        Registration _registerOperationalReader = _mountInstance_4.registerOperationalReader(ROOT_PATH, (DataReader)NetconfDevice.this);
                        NetconfDevice.this.operReaderReg = _registerOperationalReader;
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        NetconfDevice.this.logger.error("Netconf client NOT started. ", (Throwable)e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        return _function;
    }

    private void updateDeviceState() {
        try {
            DataModificationTransaction transaction = this.dataBroker.beginTransaction();
            CompositeNodeBuilder it = ImmutableCompositeNode.builder();
            it.setQName(InventoryUtils.INVENTORY_NODE);
            it.addLeaf(InventoryUtils.INVENTORY_ID, (Object)this.name);
            NetconfClientSession _clientSession = this.client.getClientSession();
            boolean _isUp = _clientSession.isUp();
            it.addLeaf(InventoryUtils.INVENTORY_CONNECTED, (Object)_isUp);
            Set _capabilities = this.client.getCapabilities();
            this.logger.debug("Client capabilities {}", (Object)_capabilities);
            Set _capabilities_1 = this.client.getCapabilities();
            for (String capability : _capabilities_1) {
                it.addLeaf(InventoryUtils.NETCONF_INVENTORY_INITIAL_CAPABILITY, (Object)capability);
            }
            Object _identifier = transaction.getIdentifier();
            String _plus = "Update device state transaction " + _identifier;
            String _plus_1 = _plus + " putting operational data started.";
            this.logger.debug(_plus_1);
            InstanceIdentifier _path = this.getPath();
            ImmutableCompositeNode _instance = (ImmutableCompositeNode)it.toInstance();
            transaction.putOperationalData((Object)_path, (Object)_instance);
            Object _identifier_1 = transaction.getIdentifier();
            String _plus_2 = "Update device state transaction " + _identifier_1;
            String _plus_3 = _plus_2 + " putting operational data ended.";
            this.logger.debug(_plus_3);
            Future _commit = transaction.commit();
            RpcResult transactionStatus = (RpcResult)_commit.get();
            boolean _isSuccessful = transactionStatus.isSuccessful();
            if (_isSuccessful) {
                Object _identifier_2 = transaction.getIdentifier();
                String _plus_4 = "Update device state transaction " + _identifier_2;
                String _plus_5 = _plus_4 + " SUCCESSFUL.";
                this.logger.debug(_plus_5);
            } else {
                Object _identifier_3 = transaction.getIdentifier();
                String _plus_6 = "Update device state transaction " + _identifier_3;
                String _plus_7 = _plus_6 + " FAILED!";
                this.logger.debug(_plus_7);
                TransactionStatus _status = transaction.getStatus();
                String _plus_8 = "Update device state transaction status " + _status;
                this.logger.debug(_plus_8);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CompositeNode readConfigurationData(InstanceIdentifier path) {
        Node<? extends Object> _filterStructure = NetconfMapping.toFilterStructure(path);
        CompositeNodeTOImpl _wrap = NetconfMapping.wrap(NetconfMapping.NETCONF_GET_CONFIG_QNAME, (Node<? extends Object>)NetconfMapping.CONFIG_SOURCE_RUNNING, _filterStructure);
        RpcResult<CompositeNode> result = this.invokeRpc(NetconfMapping.NETCONF_GET_CONFIG_QNAME, (CompositeNode)_wrap);
        CompositeNode _result = (CompositeNode)result.getResult();
        CompositeNode data = _result.getFirstCompositeByName(NetconfMapping.NETCONF_DATA_QNAME);
        Node<? extends Object> _findNode = null;
        if (data != null) {
            _findNode = NetconfDevice.findNode(data, path);
        }
        return (CompositeNode)_findNode;
    }

    public CompositeNode readOperationalData(InstanceIdentifier path) {
        Node<? extends Object> _filterStructure = NetconfMapping.toFilterStructure(path);
        CompositeNodeTOImpl _wrap = NetconfMapping.wrap(NetconfMapping.NETCONF_GET_QNAME, _filterStructure);
        RpcResult<CompositeNode> result = this.invokeRpc(NetconfMapping.NETCONF_GET_QNAME, (CompositeNode)_wrap);
        CompositeNode _result = (CompositeNode)result.getResult();
        CompositeNode data = _result.getFirstCompositeByName(NetconfMapping.NETCONF_DATA_QNAME);
        Node<? extends Object> _findNode = null;
        if (data != null) {
            _findNode = NetconfDevice.findNode(data, path);
        }
        return (CompositeNode)_findNode;
    }

    public Set<QName> getSupportedRpcs() {
        Set<QName> _emptySet = Collections.emptySet();
        return _emptySet;
    }

    public RpcResult<CompositeNode> createSubscription(String streamName) {
        RpcResult<CompositeNode> _invokeRpc;
        RpcResult<CompositeNode> _xblockexpression = null;
        CompositeNodeBuilder it = ImmutableCompositeNode.builder();
        it.setQName(NetconfMapping.NETCONF_CREATE_SUBSCRIPTION_QNAME);
        it.addLeaf("stream", streamName);
        QName _qName = it.getQName();
        ImmutableCompositeNode _instance = (ImmutableCompositeNode)it.toInstance();
        _xblockexpression = _invokeRpc = this.invokeRpc(_qName, (CompositeNode)_instance);
        return _xblockexpression;
    }

    public RpcResult<CompositeNode> invokeRpc(QName rpc, CompositeNode input) {
        try {
            Optional<SchemaContext> _schemaContext = this.getSchemaContext();
            NetconfMessage message = NetconfMapping.toRpcMessage(rpc, input, _schemaContext);
            NetconfMessage result = this.sendMessageImpl(message, this.messegeRetryCount, this.messageTimeoutCount);
            Optional<SchemaContext> _schemaContext_1 = this.getSchemaContext();
            return NetconfMapping.toRpcResult(result, rpc, _schemaContext_1);
        }
        catch (Throwable _t) {
            try {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    this.logger.error("Rpc was not processed correctly.", (Throwable)e);
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public NetconfMessage sendMessageImpl(NetconfMessage message, int retryCount, int timeout) {
        Document _document = message.getDocument();
        String _string = XmlUtil.toString((Document)_document);
        this.logger.debug("Send message {}", (Object)_string);
        NetconfMessage result = this.client.sendMessage(message, retryCount, timeout);
        NetconfMapping.checkValidReply(message, result);
        return result;
    }

    public Collection<Provider.ProviderFunctionality> getProviderFunctionality() {
        Set<Provider.ProviderFunctionality> _emptySet = Collections.emptySet();
        return _emptySet;
    }

    public void onSessionInitiated(Broker.ProviderSession session) {
        try {
            MountProvisionService _service_1;
            boolean _configurationNodeNotExisting;
            DataBrokerService _service;
            this.dataBroker = _service = (DataBrokerService)session.getService(DataBrokerService.class);
            DataModificationTransaction transaction = this.dataBroker.beginTransaction();
            boolean _operationalNodeNotExisting = this.operationalNodeNotExisting(transaction);
            if (_operationalNodeNotExisting) {
                InstanceIdentifier _path = this.getPath();
                CompositeNodeTOImpl _nodeWithId = this.getNodeWithId();
                transaction.putOperationalData((Object)_path, (Object)_nodeWithId);
            }
            if (_configurationNodeNotExisting = this.configurationNodeNotExisting(transaction)) {
                InstanceIdentifier _path_1 = this.getPath();
                CompositeNodeTOImpl _nodeWithId_1 = this.getNodeWithId();
                transaction.putConfigurationData((Object)_path_1, (Object)_nodeWithId_1);
            }
            Future _commit = transaction.commit();
            _commit.get();
            this.mountService = _service_1 = (MountProvisionService)session.getService(MountProvisionService.class);
            MountProvisionInstance _createOrGetMountPoint = null;
            if (this.mountService != null) {
                InstanceIdentifier _path_2 = this.getPath();
                _createOrGetMountPoint = this.mountService.createOrGetMountPoint(_path_2);
            }
            this.setMountInstance(_createOrGetMountPoint);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CompositeNodeTOImpl getNodeWithId() {
        SimpleNodeTOImpl _simpleNodeTOImpl;
        SimpleNodeTOImpl id = _simpleNodeTOImpl = new SimpleNodeTOImpl(InventoryUtils.INVENTORY_ID, null, (Object)this.name);
        List<SimpleNodeTOImpl> _singletonList = Collections.singletonList(id);
        CompositeNodeTOImpl _compositeNodeTOImpl = new CompositeNodeTOImpl(InventoryUtils.INVENTORY_NODE, null, _singletonList);
        return _compositeNodeTOImpl;
    }

    public boolean configurationNodeNotExisting(DataModificationTransaction transaction) {
        InstanceIdentifier _path = this.getPath();
        CompositeNode _readConfigurationData = (CompositeNode)transaction.readConfigurationData((Object)_path);
        return null == _readConfigurationData;
    }

    public boolean operationalNodeNotExisting(DataModificationTransaction transaction) {
        InstanceIdentifier _path = this.getPath();
        CompositeNode _readOperationalData = (CompositeNode)transaction.readOperationalData((Object)_path);
        return null == _readOperationalData;
    }

    public static Node<? extends Object> findNode(CompositeNode node, InstanceIdentifier identifier) {
        CompositeNode current = node;
        List _path = identifier.getPath();
        for (InstanceIdentifier.PathArgument arg : _path) {
            boolean _equals_3;
            boolean _equals_2;
            boolean _equals_1;
            if (current instanceof SimpleNode) {
                return null;
            }
            if (!(current instanceof CompositeNode)) continue;
            CompositeNode currentComposite = current;
            QName _nodeType = arg.getNodeType();
            CompositeNode _firstCompositeByName = currentComposite.getFirstCompositeByName(_nodeType);
            boolean _equals = Objects.equal((Object)(current = _firstCompositeByName), null);
            if (_equals) {
                CompositeNode _firstCompositeByName_1;
                QName _nodeType_1 = arg.getNodeType();
                QName _withoutRevision = _nodeType_1.withoutRevision();
                current = _firstCompositeByName_1 = currentComposite.getFirstCompositeByName(_withoutRevision);
            }
            if (_equals_1 = Objects.equal((Object)current, null)) {
                QName _nodeType_2 = arg.getNodeType();
                SimpleNode _firstSimpleByName = currentComposite.getFirstSimpleByName(_nodeType_2);
                current = _firstSimpleByName;
            }
            if (_equals_2 = Objects.equal((Object)current, null)) {
                QName _nodeType_3 = arg.getNodeType();
                QName _withoutRevision_1 = _nodeType_3.withoutRevision();
                SimpleNode _firstSimpleByName_1 = currentComposite.getFirstSimpleByName(_withoutRevision_1);
                current = _firstSimpleByName_1;
            }
            if (!(_equals_3 = Objects.equal((Object)current, null))) continue;
            return null;
        }
        return current;
    }

    public DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> requestCommit(DataModification<InstanceIdentifier, CompositeNode> modification) {
        NetconfDeviceTwoPhaseCommitTransaction _netconfDeviceTwoPhaseCommitTransaction;
        NetconfDeviceTwoPhaseCommitTransaction twoPhaseCommit = _netconfDeviceTwoPhaseCommitTransaction = new NetconfDeviceTwoPhaseCommitTransaction(this, modification);
        twoPhaseCommit.prepare();
        return twoPhaseCommit;
    }

    public Set<QName> getInitialCapabilities() {
        Set capabilities;
        boolean _equals;
        Set _capabilities = null;
        if (this.client != null) {
            _capabilities = this.client.getCapabilities();
        }
        if (_equals = Objects.equal((Object)(capabilities = _capabilities), null)) {
            return null;
        }
        boolean _equals_1 = Objects.equal(this.cachedCapabilities, null);
        if (_equals_1) {
            ImmutableSet _set;
            FluentIterable _from = FluentIterable.from((Iterable)capabilities);
            Predicate<String> _function = new Predicate<String>(){

                public boolean apply(String it) {
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _contains = it.contains("?");
                    if (!_contains) {
                        _and_1 = false;
                    } else {
                        boolean _contains_1 = it.contains("module=");
                        boolean bl = _and_1 = _contains && _contains_1;
                    }
                    if (!_and_1) {
                        _and = false;
                    } else {
                        boolean _contains_2 = it.contains("revision=");
                        _and = _and_1 && _contains_2;
                    }
                    return _and;
                }
            };
            FluentIterable _filter = _from.filter((Predicate)_function);
            Function<String, QName> _function_1 = new Function<String, QName>(){

                public QName apply(String it) {
                    boolean _equals;
                    boolean _tripleEquals;
                    String[] parts = it.split("\\?");
                    String namespace = parts[0];
                    String _get = parts[1];
                    String[] _split = _get.split("&");
                    FluentIterable queryParams = FluentIterable.from((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
                    Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                        public Boolean apply(String it) {
                            boolean _startsWith = it.startsWith("revision=");
                            return _startsWith;
                        }
                    };
                    String _findFirst = (String)IterableExtensions.findFirst((Iterable)queryParams, (Functions.Function1)_function);
                    String _replaceAll = null;
                    if (_findFirst != null) {
                        _replaceAll = _findFirst.replaceAll("revision=", "");
                    }
                    String revision = _replaceAll;
                    Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                        public Boolean apply(String it) {
                            boolean _startsWith = it.startsWith("module=");
                            return _startsWith;
                        }
                    };
                    String _findFirst_1 = (String)IterableExtensions.findFirst((Iterable)queryParams, (Functions.Function1)_function_1);
                    String _replaceAll_1 = null;
                    if (_findFirst_1 != null) {
                        _replaceAll_1 = _findFirst_1.replaceAll("module=", "");
                    }
                    String moduleName = _replaceAll_1;
                    boolean bl = _tripleEquals = revision == null;
                    if (_tripleEquals) {
                        boolean _notEquals;
                        NetconfDevice.this.logger.warn("Netconf device was not reporting revision correctly, trying to get amp;revision=");
                        Functions.Function1<String, Boolean> _function_2 = new Functions.Function1<String, Boolean>(){

                            public Boolean apply(String it) {
                                boolean _startsWith = it.startsWith("&amp;revision=");
                                return _startsWith;
                            }
                        };
                        String _findFirst_2 = (String)IterableExtensions.findFirst((Iterable)queryParams, (Functions.Function1)_function_2);
                        String _replaceAll_2 = null;
                        if (_findFirst_2 != null) {
                            _replaceAll_2 = _findFirst_2.replaceAll("revision=", "");
                        }
                        boolean bl2 = _notEquals = !Objects.equal((Object)(revision = _replaceAll_2), null);
                        if (_notEquals) {
                            NetconfDevice.this.logger.warn("Netconf device returned revision incorectly escaped for {}", (Object)it);
                        }
                    }
                    if (_equals = Objects.equal((Object)revision, null)) {
                        URI _create = URI.create(namespace);
                        return QName.create((URI)_create, null, (String)moduleName);
                    }
                    return QName.create((String)namespace, (String)revision, (String)moduleName);
                }
            };
            FluentIterable _transform = _filter.transform((Function)_function_1);
            this.cachedCapabilities = _set = _transform.toSet();
        }
        return this.cachedCapabilities;
    }

    @Override
    public void close() {
        try {
            if (this.confReaderReg != null) {
                this.confReaderReg.close();
            }
            if (this.operReaderReg != null) {
                this.operReaderReg.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

