/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.connector.netconf;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.connector.netconf.AbstractNetconfConnectorModule;
import org.opendaylight.controller.netconf.client.NetconfClientDispatcher;
import org.opendaylight.controller.netconf.client.NetconfSshClientDispatcher;
import org.opendaylight.controller.netconf.util.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.controller.netconf.util.handler.ssh.authentication.LoginPassword;
import org.opendaylight.controller.sal.connect.netconf.NetconfDevice;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.TimedReconnectStrategy;
import org.opendaylight.yangtools.yang.model.util.repo.AbstractCachingSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.FilesystemSchemaCachingProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProviders;
import org.osgi.framework.BundleContext;

public final class NetconfConnectorModule
extends AbstractNetconfConnectorModule {
    private static ExecutorService GLOBAL_PROCESSING_EXECUTOR = null;
    private static AbstractCachingSchemaSourceProvider<String, InputStream> GLOBAL_NETCONF_SOURCE_PROVIDER = null;
    private BundleContext bundleContext;

    public NetconfConnectorModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public NetconfConnectorModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, NetconfConnectorModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkState((this.getAddress() != null ? 1 : 0) != 0, (Object)"Address must be set.");
        Preconditions.checkState((this.getPort() != null ? 1 : 0) != 0, (Object)"Port must be set.");
        Preconditions.checkState((this.getDomRegistry() != null ? 1 : 0) != 0, (Object)"Dom Registry must be provided.");
    }

    @Override
    public AutoCloseable createInstance() {
        this.getDomRegistryDependency();
        NetconfDevice device = new NetconfDevice(this.getIdentifier().getInstanceName());
        String addressValue = this.getAddress();
        int attemptMsTimeout = 60000;
        int connectionAttempts = 5;
        TimedReconnectStrategy strategy = new TimedReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, attemptMsTimeout, 1000L, 1.0, null, Long.valueOf(connectionAttempts), null);
        device.setReconnectStrategy((ReconnectStrategy)strategy);
        InetAddress addr = InetAddresses.forString((String)addressValue);
        InetSocketAddress socketAddress = new InetSocketAddress(addr, this.getPort().intValue());
        device.setProcessingExecutor(this.getGlobalProcessingExecutor());
        device.setSocketAddress(socketAddress);
        device.setEventExecutor(this.getEventExecutorDependency());
        device.setDispatcher(this.createDispatcher());
        device.setSchemaSourceProvider(this.getGlobalNetconfSchemaProvider(this.bundleContext));
        this.getDomRegistryDependency().registerProvider((Provider)device, this.bundleContext);
        device.start();
        return device;
    }

    private ExecutorService getGlobalProcessingExecutor() {
        if (GLOBAL_PROCESSING_EXECUTOR == null) {
            GLOBAL_PROCESSING_EXECUTOR = Executors.newCachedThreadPool();
        }
        return GLOBAL_PROCESSING_EXECUTOR;
    }

    private synchronized AbstractCachingSchemaSourceProvider<String, InputStream> getGlobalNetconfSchemaProvider(BundleContext bundleContext) {
        if (GLOBAL_NETCONF_SOURCE_PROVIDER == null) {
            String storageFile = "cache/schema";
            File directory = new File("cache/schema");
            SchemaSourceProvider defaultProvider = SchemaSourceProviders.noopProvider();
            GLOBAL_NETCONF_SOURCE_PROVIDER = FilesystemSchemaCachingProvider.createFromStringSourceProvider((SchemaSourceProvider)defaultProvider, (File)directory);
        }
        return GLOBAL_NETCONF_SOURCE_PROVIDER;
    }

    private NetconfClientDispatcher createDispatcher() {
        EventLoopGroup bossGroup = this.getBossThreadGroupDependency();
        EventLoopGroup workerGroup = this.getWorkerThreadGroupDependency();
        if (this.getTcpOnly().booleanValue()) {
            return new NetconfClientDispatcher(bossGroup, workerGroup);
        }
        LoginPassword authHandler = new LoginPassword(this.getUsername(), this.getPassword());
        return new NetconfSshClientDispatcher((AuthenticationHandler)authHandler, bossGroup, workerGroup);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

