/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.connector.netconf;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.md.sal.connector.netconf.NetconfConnectorModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.config.yang.netty.EventExecutorServiceInterface;
import org.opendaylight.controller.config.yang.netty.EventLoopGroupServiceInterface;
import org.opendaylight.controller.sal.core.api.Broker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetconfConnectorModule
implements Module,
NetconfConnectorModuleMXBean {
    protected final JmxAttribute portJmxAttribute = new JmxAttribute("Port");
    private Long port;
    protected final JmxAttribute workerThreadGroupJmxAttribute = new JmxAttribute("WorkerThreadGroup");
    private ObjectName workerThreadGroup;
    protected final JmxAttribute usernameJmxAttribute = new JmxAttribute("Username");
    private String username;
    protected final JmxAttribute addressJmxAttribute = new JmxAttribute("Address");
    private String address;
    protected final JmxAttribute tcpOnlyJmxAttribute = new JmxAttribute("TcpOnly");
    private Boolean tcpOnly;
    protected final JmxAttribute eventExecutorJmxAttribute = new JmxAttribute("EventExecutor");
    private ObjectName eventExecutor;
    protected final JmxAttribute passwordJmxAttribute = new JmxAttribute("Password");
    private String password;
    protected final JmxAttribute bossThreadGroupJmxAttribute = new JmxAttribute("BossThreadGroup");
    private ObjectName bossThreadGroup;
    protected final JmxAttribute domRegistryJmxAttribute = new JmxAttribute("DomRegistry");
    private ObjectName domRegistry;
    private static final Logger logger = LoggerFactory.getLogger(AbstractNetconfConnectorModule.class);
    private final AbstractNetconfConnectorModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private EventLoopGroup workerThreadGroupDependency;
    private EventExecutor eventExecutorDependency;
    private EventLoopGroup bossThreadGroupDependency;
    private Broker domRegistryDependency;

    public AbstractNetconfConnectorModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractNetconfConnectorModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractNetconfConnectorModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public Long getPort() {
        return this.port;
    }

    @Override
    public void setPort(Long port) {
        this.port = port;
    }

    @Override
    public ObjectName getWorkerThreadGroup() {
        return this.workerThreadGroup;
    }

    @Override
    @RequireInterface(value=EventLoopGroupServiceInterface.class)
    public void setWorkerThreadGroup(ObjectName workerThreadGroup) {
        this.workerThreadGroup = workerThreadGroup;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public Boolean getTcpOnly() {
        return this.tcpOnly;
    }

    @Override
    public void setTcpOnly(Boolean tcpOnly) {
        this.tcpOnly = tcpOnly;
    }

    @Override
    public ObjectName getEventExecutor() {
        return this.eventExecutor;
    }

    @Override
    @RequireInterface(value=EventExecutorServiceInterface.class)
    public void setEventExecutor(ObjectName eventExecutor) {
        this.eventExecutor = eventExecutor;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public ObjectName getBossThreadGroup() {
        return this.bossThreadGroup;
    }

    @Override
    @RequireInterface(value=EventLoopGroupServiceInterface.class)
    public void setBossThreadGroup(ObjectName bossThreadGroup) {
        this.bossThreadGroup = bossThreadGroup;
    }

    @Override
    public ObjectName getDomRegistry() {
        return this.domRegistry;
    }

    @Override
    @RequireInterface(value=BrokerServiceInterface.class)
    public void setDomRegistry(ObjectName domRegistry) {
        this.domRegistry = domRegistry;
    }

    public void validate() {
        this.dependencyResolver.validateDependency(EventLoopGroupServiceInterface.class, this.workerThreadGroup, this.workerThreadGroupJmxAttribute);
        this.dependencyResolver.validateDependency(EventExecutorServiceInterface.class, this.eventExecutor, this.eventExecutorJmxAttribute);
        this.dependencyResolver.validateDependency(EventLoopGroupServiceInterface.class, this.bossThreadGroup, this.bossThreadGroupJmxAttribute);
        this.dependencyResolver.validateDependency(BrokerServiceInterface.class, this.domRegistry, this.domRegistryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final EventLoopGroup getWorkerThreadGroupDependency() {
        return this.workerThreadGroupDependency;
    }

    protected final EventExecutor getEventExecutorDependency() {
        return this.eventExecutorDependency;
    }

    protected final EventLoopGroup getBossThreadGroupDependency() {
        return this.bossThreadGroupDependency;
    }

    protected final Broker getDomRegistryDependency() {
        return this.domRegistryDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.workerThreadGroupDependency = (EventLoopGroup)this.dependencyResolver.resolveInstance(EventLoopGroup.class, this.workerThreadGroup, this.workerThreadGroupJmxAttribute);
            this.eventExecutorDependency = (EventExecutor)this.dependencyResolver.resolveInstance(EventExecutor.class, this.eventExecutor, this.eventExecutorJmxAttribute);
            this.bossThreadGroupDependency = (EventLoopGroup)this.dependencyResolver.resolveInstance(EventLoopGroup.class, this.bossThreadGroup, this.bossThreadGroupJmxAttribute);
            this.domRegistryDependency = (Broker)this.dependencyResolver.resolveInstance(Broker.class, this.domRegistry, this.domRegistryJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractNetconfConnectorModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractNetconfConnectorModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.workerThreadGroupDependency != other.workerThreadGroupDependency) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.tcpOnly == null ? other.tcpOnly != null : !this.tcpOnly.equals(other.tcpOnly)) {
            return false;
        }
        if (this.eventExecutorDependency != other.eventExecutorDependency) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.bossThreadGroupDependency != other.bossThreadGroupDependency) {
            return false;
        }
        return this.domRegistryDependency == other.domRegistryDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNetconfConnectorModule that = (AbstractNetconfConnectorModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

